<?php

namespace cnb\admin\legacy;

// don't load directly
defined( 'ABSPATH' ) || die( '-1' );

use cnb\CnbHeaderNotices;

class CnbLegacyUpgrade {
    function header() {
        echo 'Create Account';
    }

    private function feature_comparison_free_promobox() {
        ?>
        <style>
          @font-face {
            font-family: 'CNB Icons';
            font-style: normal;
            font-weight: 400;
            src: url("<?php echo esc_url(WP_PLUGIN_URL . '/' . CNB_BASEFOLDER . '/resources/font/cnb.woff');?>") format('woff2');
          }
          .cnb-font-icon i {
            font-family: 'CNB Icons';
            outline: none;
            font-style: normal;
            letter-spacing: normal;
            text-transform: none;
            display: inline-block;
            white-space: nowrap;
            word-wrap: normal;
            direction: ltr;
            -webkit-font-smoothing: antialiased;
            text-rendering: optimizeLegibility;
            -webkit-font-feature-settings: 'liga';
          }
          .cnb-compare-features {
            max-width: 800px;
          }
          .benefit-number {
            /* padding-bottom: 10px; */
            box-sizing: border-box;
            min-height: 32px;
            font-weight: 400
          }
          .benefit-number,
          .cnb-font-icon i,
          .cnb-font-icon span {
            font-size: 32px;
          }
          .cnb-font-icon .dashicons {
            width: auto;
            height: auto;
            font-size: 26px;
          }
          .benefit-section {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;

          }
          .benefit-box {
            width: 70px;
            min-width:70px;
            height: 80px;
            margin: 20px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 5px;
            border-radius: 5px;
            text-align: center;
            background: #fff;
            font-size: 14px;
            font-weight: 200;
            box-shadow: rgba(50, 50, 93, 0.25) 0px 13px 27px -5px, rgba(0, 0, 0, 0.3) 0px 8px 16px -8px;
          }
          .wrap.call-now-button-plugin {
            font-family: BlinkMacSystemFont,-apple-system,Segoe UI,Roboto, Helvetica, Arial,sans-serif;
          }
          .call-now-button-plugin h1 {
            font-size: 60px;
            line-height: 1.2;
            font-weight: 600;
            margin: 0;
          }
          .cnb-compare-features h2 {
            font-size: 40px;
            line-height: 1.25;
            font-weight: 600;
            margin: 0.5em 0;
          }
          .cnb-compare-features h3 {
            font-size: 30px;
            font-weight: 600;
            margin: 0.5em 0;
          }
          .cnb-compare-features th h3 {
            font-size:18px;
            margin:1em 0;
          }
          .cnb-compare-features p,
          .cnb-compare-features table tbody th {
            font-size:16.5px;
            font-weight: 300;
            line-height:1.4;
          }
          .cnb-faq-section {
            max-width: 800px;
          }
          .cnb-faq-section h3 {
            font-size:18px;
          }
          .cnb-faq-section p {
            font-size:14px;
          }
          .benefits-section-signup p.nonessential {
            font-size: 14px;
            padding-left: 0
          }

          .cnb-compare-features .benefits-section-signup .button-primary {
            font-size: 20px;
            padding: 4px 10px;
            box-shadow: rgba(50, 50, 93, 0.25) 0px 13px 27px -5px, rgba(0, 0, 0, 0.3) 0px 8px 16px -8px;
          }
          @media screen and (max-width: 782px) {
            .cnb-compare-features .benefits-section-signup .button-primary {
              vertical-align:top;
              padding: 2px 10px;
            }
          }
          .cnb-body-content .benefits-section-signup form.cnb-container input[type=text] {
            max-width: calc(100% - 190px);
            font-size: 26px;
            box-shadow: rgba(50, 50, 93, 0.25) 0px 13px 27px -5px, rgba(0, 0, 0, 0.3) 0px 8px 16px -8px;
          }
          @media screen and (max-width: 450px) {
            .cnb-body-content .benefits-section-signup form.cnb-container input[type=text] {
              max-width: 100%;
            }
          }
        </style>
        <h2>Activate more features</h2>
        <p>When signing up you activate the NowButtons cloud features.</p>
        <div class="benefit-section">
          <div class="benefit-box">
            <span class="benefit-number">5</span>
            <span class="benefit-name">Buttons</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><span class="dashicons dashicons-desktop"></span></span>
            <span class="benefit-name">Desktop</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><span class="dashicons dashicons-flag"></span></span>
            <span class="benefit-name">Rules</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><span class="dashicons dashicons-visibility"></span></span>
            <span class="benefit-name">Preview</span>
          </div>
        </div>
        <h2>Enable more actions</h2>
        <p>NowButtons brings you a full suite of actions to boost the overal conversion rate of your website. Sign up now to enable the following actions:</p>
        <div class="benefit-section">
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>whatsapp</i></span>
            <span class="benefit-name">WhatsApp</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>email</i></span>
            <span class="benefit-name">EMail</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>directions</i></span>
            <span class="benefit-name">Maps</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>link2</i></span>
            <span class="benefit-name">Links</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>anchor</i></span>
            <span class="benefit-name">Scrolls</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>facebook_messenger</i></span>
            <span class="benefit-name">Messenger</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>telegram</i></span>
            <span class="benefit-name">Telegram</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>signal</i></span>
            <span class="benefit-name">Signal</span>
          </div>
          <div class="benefit-box">
            <span class="benefit-number cnb-font-icon"><i>sms</i></span>
            <span class="benefit-name">SMS/Text</span>
          </div>
        </div>
        <h3 style="padding-top:30px;" id="cnb-sign-up-here">Sign up, it's free!</h3>
        <p style="margin-top:30px"><b>Enter your email below</b> and hit <i>Create account</i> to activate NowButtons:</p>
        <div class="benefits-section-signup">
          <?php echo CnbHeaderNotices::cnb_settings_email_activation_input() // phpcs:ignore WordPress.Security ?>
        </div>
        <div class="cnb-body-column">
          <hr style="margin:50px 0">
          <h2>Feature comparison</h2>
                <table class="cnb-nb-plans">
                  <thead>
                    <tr>
                      <td></td>
                      <th class="cnb-prod-cnb" style="border-radius:5px 5px 0 0;"><h3>No account<br><span style="font-weight:normal;">(Currently active)</span></h3></th>
                      <th class="cnb-prod-nb" style="border-radius:5px 5px 0 0;"><h3>With account<br><span style="font-weight:normal;">(NowButtons.com)</span></h3></th>
                    </tr>
                    <tr class="font-18">
                      <th style="border-radius: 5px 0 0 5px;"></th>
                      <th><h4>Free</h4></th>
                      <th><h4>Free</h4></th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                    <tr>
                      <th>No. of buttons</th>
                      <td class="value">1</td>
                      <td class="value">5</td>
                    </tr>
                    <tr>
                      <th>Single button</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Buttonbar (full width)</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                    <tr>
                      <th>Phone</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>SMS/Text</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Email</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Maps</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>URLs</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Scroll to point</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>WhatsApp</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Messenger</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Telegram</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Signal</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>

                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                    <tr>
                      <th>Mobile</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Desktop</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Limit appearance</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Display rules (Basic)</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Click tracking in GA</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Google Ads conversion tracking</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Live preview</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                  </tbody>
                </table>
                <h3>Sign up now (no cost!)</h3>
                <p><a style="color:#00aa00; font-weight:400" href="#cnb-sign-up-here">Sign up above</a> to create your NowButtons account. Once you've confirmed your account via email, your Call Now Button plugin is automatically upgraded to <b><?php echo esc_html(CNB_CLOUD_NAME) ?></b>.</p>
        </div>
    <?php }

    function upgrade_faq() {
        ?>
        <div class="cnb-faq-section">
            <h1>FAQ</h1>
            <h3>Is a NowButtons.com account really free?</h3>
            <p>Yes. NowButtons has a paid plan as well, however the features described above are all part of the Starter plan which is free. Enter your email above and click <b>Create account</b> to sign up and enable the extra features.</p>
            <h3>Is there a PRO plan?</h3>
            <p>Yes, NowButtons offers a PRO plan with many advanced feature for even more buttons and more control.</p>
            <h3>What's included in PRO?</h3>
            <p>PRO turns your website into a conversion machine. It adds a big collection of premium features such as scheduling, multi-action buttons, animations, WhatsApp Chat window, and much much more. Checkout <a href="<?php echo esc_html(CNB_WEBSITE) ?>pricing/" target="_blank"><?php echo esc_html(CNB_WEBSITE) ?>pricing/</a> for a full features overview.</p>
            <h3>Why do I have to sign up for <?php echo esc_html(CNB_CLOUD_NAME); ?>?</h3>
            <p>NowButtons is a cloud service and can be added to any website. Even those that do not have a WordPress powered website. Once you've signed up, you can continue to manage your buttons from your WordPress instance, but you could also do this via the web app found at <a href="<?php echo esc_html(CNB_APP) ?>" target="_blank"><?php echo esc_html(CNB_APP) ?></a>.</p><p>And should you ever move to a different CMS, your button(s) will just move with you.</p>
        </div>
    <?php }

    public function render() {
        do_action( 'cnb_init', __METHOD__ );
        wp_enqueue_script( CNB_SLUG . '-settings' );
        wp_enqueue_script( CNB_SLUG . '-premium-activation' );

        add_action( 'cnb_header_name', array( $this, 'header' ) );
        do_action( 'cnb_header' );
        ?>

        <div class="cnb-one-column-section">
            <div class="cnb-body-content">
                <div class="cnb-compare-features">
                    <?php $this->feature_comparison_free_promobox() ?>
                    <hr style="margin:50px 0">
                    <?php $this->upgrade_faq() ?>
                </div>
            </div>
        </div>
        <hr>
        <?php
        do_action( 'cnb_footer' );
        do_action( 'cnb_finish' );
    }
}
